using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Data;

namespace IndianHealthService.BMXNet.Tests
{

    /// <summary>
    /// BMX ADO SS^BMX TEST FILE^^~~~~~
    /// 
    /// </summary>
    /// 
    public class FrameworkEvents : BmxValidUserTestSuite
    {

        private DataRow _testRow;

        public DataRow TestRow
        {
            get { return _testRow; }
            set { _testRow = value; }
        }
        private DataTable _testTable;

        public DataTable TestTable
        {
            get { return _testTable; }
            set { _testTable = value; }
        }

        public bool GenerateValidTestRow()
        {
            try
            {
                //smh -- need to remove the old row here...
                DataTable table = this.RemoteSession.TableFromCommand(this.FetchTableString);

                foreach (DataRow each in table.Rows)
                {
                    each.Delete();
                }
                this.RemoteSession.SaveChanges(table);
                //smh -end changes

                table = this.RemoteSession.TableFromCommand(this.FetchTableString);
                DataRow row = table.NewRow();
                row["NAME"] = "John";
                row["DATE"] = new DateTime(1970, 10, 10);
                row["NUMBER"] = 8;
                row["NUMBER R/O"] = 9;
                table.Rows.Add(row);
                Assert.AreEqual(1, table.Rows.Count);

                Assert.IsTrue(this.RemoteSession.SaveChanges(table));

                this.TestTable = this.RemoteSession.TableFromCommand(this.FetchTableString);
                Assert.AreEqual(1, this.TestTable.Rows.Count);
                this.TestRow = this.TestTable.Rows[0];
                Assert.AreEqual(row["NAME"], "John");
                Assert.AreEqual(row["DATE"], new DateTime(1970, 10, 10));
                return true;
            }
            catch
            {
                return false;
            }
        }

        public bool RefetchTestRow()
        {
            try
            {
                this.TestTable = this.RemoteSession.TableFromCommand(this.FetchTableString);
                Assert.AreEqual(1, this.TestTable.Rows.Count);
                this.TestRow = this.TestTable.Rows[0];
                return true;
            }
            catch
            {
                return false;
            }
        }


        [Test]
        public void RowUpdatingEvent()
        {

            this.RowUpdatingEventMade = false;
            this.GenerateValidTestRow();
            this.TestTable.RowChanging += new DataRowChangeEventHandler(TestTable_RowChanging);

            this.TestRow["NAME"] = "T";

            Assert.IsTrue(this.RowUpdatingEventMade);

        }

        private bool _rowUpdatingEventMade = false;

        public bool RowUpdatingEventMade
        {
            get { return _rowUpdatingEventMade; }
            set { _rowUpdatingEventMade = value; }
        }

     
        void TestTable_RowChanging(object sender, DataRowChangeEventArgs e)
        {
            this.RowUpdatingEventMade = true;

        }



        [Test]
        public void RowDeletedEvent()
        {

            this.RowDeleted = false;
            this.GenerateValidTestRow();
            this.TestTable.RowDeleted += new DataRowChangeEventHandler(TestTable_RowDeleted);

            this.TestRow.Delete();

            Assert.IsTrue(this.RowDeleted);

        }

        private bool _rowDeleted = false;

        public bool RowDeleted
        {
            get { return _rowDeleted; }
            set { _rowDeleted = value; }
        }

        void TestTable_RowDeleted(object sender, DataRowChangeEventArgs e)
        {
            this.RowDeleted = true;
        }


     
    }
}
